<?php 
// Include header
include "header.php";

// Safely start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check authentication
if (!function_exists('auth') || !auth()->check()) {
    if (function_exists('lib')) {
        lib()->redirect("login.php");
    } else {
        header("Location: login.php");
        exit;
    }
} else {
    // Get user type
    $userType = function_exists('auth') ? auth()->type() : null;

    if ($userType === "admin") {
        // ✅ Adjust path to match your real folder (attendence/attendance)
        $adminPage = "view/admin/attendence/attendence.php";
        
        if (file_exists($adminPage)) {
            include $adminPage;
        } else {
            echo "<p style='color:red;'>Admin page not found at: {$adminPage}</p>";
        }

    } elseif ($userType === "student") {
        $studentPage = "view/student/home.php";
        
        if (file_exists($studentPage)) {
            include $studentPage;
        } else {
            echo "<p style='color:red;'>Student page not found at: {$studentPage}</p>";
        }

    } else {
        echo "<p style='color:red;'>Unknown user type!</p>";
    }
}
?>
